package centralSystem;

import java.util.ArrayList;

public class CentralSystem implements ICentralSystem {

	private Queue[] queues = {new Queue(), new Queue(), new Queue()};
	private ArrayList<IPostCounter> counters = new ArrayList<IPostCounter>();
	private ITicketPrinter ticketPrinter;
	private IVisualizer visualizer;
	
	public CentralSystem(ITicketPrinter ticketPrinter, IVisualizer visualizer) {
		super();
		this.ticketPrinter = ticketPrinter;
		this.visualizer = visualizer;
	}

	/* (non-Javadoc)
	 * @see centralSystem.ICentralSystem#addClientAtQueue(int)
	 */
	@Override
	public void addClientAtQueue(int index){
		queues[index].addClient();
		this.ticketPrinter.printTicket(queues[index].getTotalClient());
	}
	
	/* (non-Javadoc)
	 * @see centralSystem.ICentralSystem#clientServedAtQueue(int)
	 */
	@Override
	public void clientServedAtQueue(int index){
		queues[index].clientServed();
	}
	
	/* (non-Javadoc)
	 * @see centralSystem.ICentralSystem#getTotalClient(int)
	 */
	@Override
	public int getTotalClient(int index) {
		return queues[index].getTotalClient();
	}
	
	/* (non-Javadoc)
	 * @see centralSystem.ICentralSystem#getNextClient(int)
	 */
	@Override
	public int getNextClient(int index) {
		return queues[index].getNextClient();
	}
	
	@Override
	/*
	 * (non-Javadoc)
	 * @see centralSystem.ICentralSystem#countersNumber()
	 */
	public int countersNumber(){
		return counters.size();
	}
	
	@Override
	/*
	 * (non-Javadoc)
	 * @see centralSystem.ICentralSystem#nextService(int)
	 */
	public int nextService(int index){
		visualizer.insert(index, counters.get(index).getHandled(), this.getNextClient(counters.get(index).getHandled()));
		return counters.get(index).nextService();
	}
	
	@Override
	/*
	 * (non-Javadoc)
	 * @see centralSystem.ICentralSystem#addCounter(centralSystem.IPostCounter)
	 */
	public void addCounter(IPostCounter counter){
		counters.add(counter);
	}
}
